* Przepiorka, Wojtek, Lukas Norbutas and Rense Corten. 2017:
* Order without law: Reputation promotes cooperation in a cryptomarket for illegal drugs.
* European Sociological Review 33 (6), 752-764.
* DOI: 10.1093/esr/jcx072

clear
version 14.0
set more off
capture log close

log using analysis.log, replace

use "srdata.dta", clear

*********************************************

* (1) definition of variables

*********************************************

*****************************
* a) product/item properties
*****************************

** Some fine tuning
replace poorqual = 1 if trim
drop trim
lab var poorqual "Poor quality product" 

* Labeling categorical variable
ren category cat
lab def cat 22 "Weed" 23 "Hash" 33 "MDMA" 49 "Heroin" 53 "Cocaine" 54 "Meth" 59 "Ketamine"
lab val cat cat

* Summarizing product catgeories into low medium and high stake products
gen cat2 = 1*(cat==22 | cat==23) + 2*(cat==33 | cat==53 | cat==59) + 3*(cat==49 | cat==54)
lab var cat2 "Item price category"
lab def cat2 1 "low price" 2 "medium price" 3 "high price"
lab val cat2 cat2

gen lweight = log(weight)
lab var lweight "log(weight)"

* Sales (yes/no)
gen sold = !nosales
lab var sold "Item sold at least once"

* Item's rep
gen nisales =_5si+_4si+_3si+_2si+_1si
replace nisales = 0 if sold == 0
lab var nisales "Number of item sales (incl. 0)"
gen nisales2 = nisales
replace nisales2 =. if sold==0
gen lnisales = log(nisales+1)
lab var lnisales "log(nisales+1)"
gen lnisales2 = log(nisales2)
lab var lnisales2 "log(nisales2)"
gen l5si = log(_5si)
lab var l5si "log(fivestar_item)"
gen _4321i = _4si+_3si+_2si+_1si
lab var _4321i "total 4321 ratings/item"
gen ln5si = log(_4321i + 1)
lab var ln5si "log(non5star_item+1)"

* Sales per day
gen odur = online_duration
replace odur = 0.5 if odur==0
lab var odur "Time item online (in d)"
gen lodur = log(odur)
lab var lodur "log(odur)"
gen nisperd = nisales/odur
lab var nisperd "Item sales per day (incl. 0)"
gen nisperd2 = nisales2/odur
lab var nisperd2 "Item sales per day (excl. 0)"
gen lnispd = log(nisperd+1)
lab var lnispd "log(nisperd+1)"
gen lnispd2 = log(nisperd2)
lab var lnispd2 "log(nisperd2)"

* Time
ren firstseen_cut timeind1
lab var timeind1 "Time item first seen (in d)"
gen timeindc = timeind1 - 199
lab var timeindc "timeind - 199 (centered)"
gen timeind2 = timeind1 + online_duration
lab var timeind2 "Time item last seen (in d)"
gen last2d = (timeind2==398 | timeind2==399)
lab var last2d "Last two days"

***********************
* b) seller properties
***********************

egen sid = group(seller)
lab var sid "Seller ID"

bys sid (timeind1): gen ips = _N
lab var ips "Items per seller"
bys sid (timeind1): gen ios = _n
lab var ios "Item of seller"
gen lips = log(ips)
lab var lips "log(Items per seller)"

* Seller's rep (item averaged)
gen l5ss = log(_5ss_av)
lab var l5ss "log(_5ss_av)"
gen ln5ss = log(_3ss_av+_2ss_av+_1ss_av +1)
lab var ln5ss "log(_321ss_av+1)"
gen ln5ss_2 = log(_4ss_av + _3ss_av+_2ss_av+_1ss_av +1)
lab var ln5ss_2 "log(_4321ss_av+1)"

* Seller's rep (on "item first seen" date)
gen l5ssfs = log(_5ss_fs+1)
lab var l5ssfs "log(_5ss_fs+1)"
gen ln5ssfs = log(_3ss_fs+_2ss_fs+_1ss_fs+1)
lab var ln5ssfs "log(_321ss_fs+1)"
gen ln5ssfs_2 = log(_4ss_fs+_3ss_fs+_2ss_fs+_1ss_fs+1)
lab var ln5ssfs "log(_4321ss_fs+1)"
gen _n5ss_fs = _4ss_fs + _3ss_fs + _2ss_fs + _1ss_fs
lab var _n5ss_fs "# seller non-5-star ratings at item first seen"

* Number of competitors
gen litcmp = log(itcomp+1)
lab var litcmp "log(itcomp+1)"
gen litcmpfs = log(itcompfs+1)
lab var litcmpfs "log(itcompfs+1)"

* Seller origin
gen sor = 1 if shipsfrom=="United States of America" | shipsfrom=="US"
replace sor = 2 if shipsfrom=="United Kingdom" | shipsfrom=="Ships from: United Kingdom<br />"
replace sor = 3 if shipsfrom=="Netherlands"
replace sor = 4 if shipsfrom=="Canada"
replace sor = 5 if shipsfrom=="Germany"
replace sor = 6 if shipsfrom=="Australia"
replace sor = 7 if shipsfrom=="undeclared" | shipsfrom=="Anywhere" | shipsfrom==""
replace sor = 8 if shipsfrom=="Spain"
replace sor = 9 if shipsfrom=="Italy"
replace sor = 10 if shipsfrom=="France"
replace sor = 11 if shipsfrom=="Austria"
replace sor = 12 if shipsfrom=="Poland"
replace sor = 13 if shipsfrom=="South Africa"
replace sor = 14 if shipsfrom=="India"
replace sor = 15 if shipsfrom=="Belgium" | shipsfrom=="Ships from: Belgium<br />" ///
| shipsfrom=="Finland" | shipsfrom=="Sweden" | shipsfrom=="Denmark" | shipsfrom=="Switzerland" ///
| shipsfrom=="Czech Republic" | shipsfrom=="EU" | shipsfrom=="Ireland" | shipsfrom=="Norway"
replace sor = 16 if shipsfrom=="New Zealand" | shipsfrom=="Mexico" ///
| shipsfrom=="Netherland Antilles" | shipsfrom=="Nevis" | shipsfrom=="Saipan" ///
| shipsfrom=="Swaziland" | shipsfrom=="Uzbekistan"
lab def sor 1"US" 2"GB" 3"NL" 4"CA" 5"DE" 6"AU" 7"unknown" 8"ES" 9"IT" 10"FR" 11"AT" ///
12"PL" 13"ZA" 14"IN" 15"other EU" 16"other"
lab val sor sor
lab var sor "Seller origin"

* Seller ships to
gen sto = "US and/or CA" if shipsto=="United States of America" | shipsto=="USA and Canada" ///
| shipsto=="US" | shipsto=="Canada"
replace sto = "worldwide" if shipsto=="Worldwide" | shipsto=="Anywhere" | shipsto=="worldwide" ///
| shipsto=="EU, USA, and Canada"
replace sto = "GB" if shipsto=="United Kingdom"
replace sto = "EU" if shipsto=="European Union" | shipsto=="EU, CH, and NO" | shipsto=="EU except Italy"
replace sto = "worldwide not US" if shipsto=="Worldwide except USA"
replace sto = "AU and/or NZ" if shipsto=="Australia" | shipsto=="Australia and New Zeland" ///
| shipsto=="New Zealand"
replace sto = "DE" if shipsto=="Germany"
replace sto = "other/unknown" if shipsto=="Finland" | shipsto=="Italy" | shipsto=="Oman" ///
| shipsto=="Ships from: Belgium<br />" | shipsto=="Ships from: United Kingdom<br />" ///
| shipsto=="Sweden" | shipsto=="undeclared"

* Seller ships to II
gen sto2 = 1 if sor == 7 | shipsto=="Ships from: Belgium<br />" ///
| shipsto=="Ships from: United Kingdom<br />" | shipsto=="undeclared" ///
| (shipsfrom=="Anywhere" & shipsto=="Anywhere")
replace sto2 = 2 if shipsfrom==shipsto & sto2 ==.
replace sto2 = 3 if shipsfrom!=shipsto & sto2==.
assert sto2!=.
lab def sto2 1 "unknown" 2 "domestic only" 3 "foreign"
lab val sto2 sto2
lab var sto2 "Seller ships to"
qui: tab sto2, gen(sto2)

*********************************************

* (2) descriptive statistics

*********************************************

* Table 1
tabstat nisales odur nisperd _5ss_fs _n5ss_fs _4ss_fs _3ss_fs _2ss_fs _1ss_fs sto2 if sold, ///
stat(count mean med sd p5 p25 p75 p95 min max) columns(stat) format(%9.2f)

tabstat weight price_pergram poorqual if sold, by(cat2) not long ///
stat(count mean med sd p5 p25 p75 p95 min max) columns(stat) format(%9.2f)


*********************************************

* (3) regression analyses

*********************************************

* set panel variable (seller id)
xtset sid

* Analyses using l5ssfs & ln5ssfs (cumulative 5- and non-5 star seller ratings at "item first seen")

// Price
* Full reputation model with reduced set of product categories (model M3 in Table S1)
reg logitem_price_per lweight ib1.cat2 ib0.poorqual l5ssfs ln5ssfs_2 lnisales2 ib2.sto2 ib0.last2d, cluster(sid)
est save tables/01price_ols1_2, replace
* FE full reputation model with reduced set of product categories (model M1 in Table 2)
xtreg logitem_price_per lweight ib1.cat2 ib0.poorqual l5ssfs ln5ssfs_2 lnisales2 ib2.sto2 ib0.last2d, fe cluster(sid)
est save tables/02price_fereg1_2, replace

// Sales per day
* Full reputation model with reduced set of product categories (model M4 in Table S1)
reg lnispd2 logitem_price_per lweight ib1.cat2 ib0.poorqual l5ssfs ln5ssfs_2 ib2.sto2 ib0.last2d, cluster(sid)
est save tables/01sales_ols1_2, replace
* FE full reputation model with reduced set of product categories (model M2 in Table 2)
xtreg lnispd2 logitem_price_per lweight ib1.cat2 ib0.poorqual l5ssfs ln5ssfs_2 ib2.sto2 ib0.last2d, fe cluster(sid)
est save tables/02sales_fereg1_2, replace

// Sold at least once
* Logit of probability of sale (model M5 in Table S2)
logit sold logitem_price_per lweight ib1.cat2 ib0.poorqual l5ssfs ln5ssfs_2 ib2.sto2 lodur ib0.last2d, cluster(sid)
est save tables/01sold_logit, replace
* Logit of probability of sale with seller fixed effects (model M6 in Table S2)
xtlogit sold logitem_price_per lweight ib1.cat2 ib0.poorqual l5ssfs ln5ssfs_2 ib2.sto2 lodur ib0.last2d, fe 
est save tables/02sold_logitfe, replace


*********************************************

* (4) make figures

*********************************************

*** Figure 1A

est use tables/02price_fereg1_2
eret di
nlcom 15.50*(exp(_b[l5ssfs]*ln(10))-1)
nlcom 15.50*(exp(_b[ln5ssfs_2]*ln(3))-1)
nlcom 92.26*(exp(_b[l5ssfs]*ln(10))-1)
nlcom 92.26*(exp(_b[ln5ssfs_2]*ln(3))-1)
nlcom 217.6*(exp(_b[l5ssfs]*ln(10))-1)
nlcom 217.6*(exp(_b[ln5ssfs_2]*ln(3))-1)

gen temp1=1.25 in 1
gen temp2=1.75 in 2
replace temp1=3.25 in 3
replace temp2=3.75 in 4
replace temp1=5.25 in 5
replace temp2=5.75 in 6
gen delta=1.056511 in 1
replace delta=-.7307293 in 2
replace delta=6.288624 in 3
replace delta=-4.349489 in 4
replace delta=14.83205 in 5
replace delta=-10.2585 in 6
gen lob=.532708 in 1
replace lob=-1.253864 in 2
replace lob=3.170815 in 3
replace lob=-7.463325 in 4
replace lob=7.478532 in 5
replace lob=-17.60264 in 6
gen upb=1.580313 in 1
replace upb=-.2075941 in 2
replace upb=9.406433 in 3
replace upb=-1.235654 in 4
replace upb=22.18556 in 5
replace upb=-2.914354 in 6

format delta %9.2f

twoway (bar delta temp1, sort barw(.5) color(ltblue)) (rcap lob upb temp1, sort lc(black) lw(medthin)) ///
(bar delta temp2, sort barw(.5) color(red)) (rcap lob upb temp2, sort lc(black) lw(medthin)) ///
(scatter delta temp1, sort m(i) mlabel(delta) mlabs(medsmall) mlabp(11) mlabg(*1) mlabc(black)) ///
(scatter delta temp2, sort m(i) mlabel(delta) mlabs(medsmall) mlabp(5) mlabg(*1) mlabc(black)), ///
ytitle("Change in item price (in USD)") yline(0, lwidth(vthin) lcolor(black)) ylabel(-20(5)25, labsize(medsmall) format(%9.0f) angle(0) nogrid) ///
xlabel(1.5 "low price" 3.5 "medium price" 5.5 "high price", noticks labsize(medsmall)) xscale(range(0.6 6.4) noline) ///
legend(order(1 "10-fold increase in 5-star ratings" 3 "3-fold increase in non-5-star ratings" 2 "95%-CI") size(medsmall) symx(*0.5) cols(1) position(11) ring(0)) ///
graphregion(color(white) margin(zero))
graph export graphics/Figure1a.eps, replace logo(off)

drop temp* delta lob upb


*** Figure 1B

est use tables/02sales_fereg1_2
eret di
nlcom 1.0*(exp(_b[l5ssfs]*ln(10))-1)
nlcom 1.0*(exp(_b[ln5ssfs_2]*ln(3))-1)
nlcom 2.5*(exp(_b[l5ssfs]*ln(10))-1)
nlcom 2.5*(exp(_b[ln5ssfs_2]*ln(3))-1)
nlcom 5.0*(exp(_b[l5ssfs]*ln(10))-1)
nlcom 5.0*(exp(_b[ln5ssfs_2]*ln(3))-1)

gen temp1=1.25 in 1
gen temp2=1.75 in 2
replace temp1=3.25 in 3
replace temp2=3.75 in 4
replace temp1=5.25 in 5
replace temp2=5.75 in 6
gen delta=.1473237 in 1
replace delta=-.1866202 in 2
replace delta=.3683093 in 3
replace delta=-.4665506 in 4
replace delta=.7366187 in 5
replace delta=-.9331012 in 6
gen lob=.0020465 in 1
replace lob=-.2858176 in 2
replace lob=.0051162 in 3
replace lob=-.7145439 in 4
replace lob=.0102325 in 5
replace lob=-1.429088 in 6
gen upb=.292601 in 1
replace upb=-.0874229 in 2
replace upb=.7315024 in 3
replace upb=-.2185573 in 4
replace upb=1.463005 in 5
replace upb=-.4371145 in 6

format delta %9.2f

twoway (bar delta temp1, sort barw(.5) color(ltblue)) (rcap lob upb temp1, sort lc(black) lw(medthin)) ///
(bar delta temp2, sort barw(.5) color(red)) (rcap lob upb temp2, sort lc(black) lw(medthin)) ///
(scatter delta temp1, sort m(i) mlabel(delta) mlabs(medsmall) mlabp(11) mlabg(*1) mlabc(black)) ///
(scatter delta temp2, sort m(i) mlabel(delta) mlabs(medsmall) mlabp(5) mlabg(*1) mlabc(black)), ///
ytitle("Change in item sales per 10 days") yline(0, lwidth(vthin) lcolor(black)) ylabel(-1.5(.5)1.5, labsize(medsmall) format(%9.1f) angle(0) nogrid) ///
xlabel(1.5 "25-percentile seller" 3.5 "50-percentile seller" 5.5 "75-percentile seller", noticks labsize(medsmall)) xscale(range(0.6 6.4) noline) ///
legend(order(1 "10-fold increase in 5-star ratings" 3 "3-fold increase in non-5-star ratings" 2 "95%-CI") size(medsmall) symx(*0.5) cols(1) position(11) ring(0)) ///
graphregion(color(white) margin(zero))
graph export graphics/Figure1b.eps, replace logo(off)

drop temp* delta lob upb


*** Figure S1A

est use tables/02price_fereg1_2
eret di
nlcom 15.50*(exp(_b[l5ssfs]*ln(10))-1)
nlcom 15.50*(exp(_b[ln5ssfs_2]*ln(3))-1)
nlcom 92.26*(exp(_b[l5ssfs]*ln(10))-1)
nlcom 92.26*(exp(_b[ln5ssfs_2]*ln(3))-1)
nlcom 217.6*(exp(_b[l5ssfs]*ln(10))-1)
nlcom 217.6*(exp(_b[ln5ssfs_2]*ln(3))-1)

gen temp1a=1.125 in 1
gen temp2a=1.625 in 2
replace temp1a=3.125 in 3
replace temp2a=3.625 in 4
replace temp1a=5.125 in 5
replace temp2a=5.625 in 6
gen deltaa=1.056511 in 1
replace deltaa=-.7307293 in 2
replace deltaa=6.288624 in 3
replace deltaa=-4.349489 in 4
replace deltaa=14.83205 in 5
replace deltaa=-10.2585 in 6
gen loba=.532708 in 1
replace loba=-1.253864 in 2
replace loba=3.170815 in 3
replace loba=-7.463325 in 4
replace loba=7.478532 in 5
replace loba=-17.60264 in 6
gen upba=1.580313 in 1
replace upba=-.2075941 in 2
replace upba=9.406433 in 3
replace upba=-1.235654 in 4
replace upba=22.18556 in 5
replace upba=-2.914354 in 6

est use tables/01price_ols1_2
eret di
nlcom 15.50*(exp(_b[l5ssfs]*ln(10))-1)
nlcom 15.50*(exp(_b[ln5ssfs_2]*ln(3))-1)
nlcom 92.26*(exp(_b[l5ssfs]*ln(10))-1)
nlcom 92.26*(exp(_b[ln5ssfs_2]*ln(3))-1)
nlcom 217.6*(exp(_b[l5ssfs]*ln(10))-1)
nlcom 217.6*(exp(_b[ln5ssfs_2]*ln(3))-1)

gen temp1b=1.375 in 1
gen temp2b=1.875 in 2
replace temp1b=3.375 in 3
replace temp2b=3.875 in 4
replace temp1b=5.375 in 5
replace temp2b=5.875 in 6
gen deltab=1.362204 in 1
replace deltab=-.9149185 in 2
replace deltab=8.108188 in 3
replace deltab=-5.445831 in 4
replace deltab=19.12358 in 5
replace deltab=-12.84428 in 6
gen lobb=.7074668 in 1
replace lobb=-1.510158 in 2
replace lobb=4.211025 in 3
replace lobb=-8.988852 in 4
replace lobb=9.931921 in 5
replace lobb=-21.20067 in 6
gen upbb=2.016941 in 1
replace upbb=-.3196789 in 2
replace upbb=12.00535 in 3
replace upbb=-1.902811 in 4
replace upbb=28.31524 in 5
replace upbb=-4.487879 in 6

format deltaa deltab %9.2f

twoway (bar deltaa temp1a, sort barw(.25) color(ltblue)) (rcap loba upba temp1a, sort lc(black) lw(medthin)) ///
(bar deltaa temp2a, sort barw(.25) color(red)) (rcap loba upba temp2a, sort lc(black) lw(medthin)) ///
(scatter deltaa temp1a, sort m(i) mlabel(deltaa) mlabs(medsmall) mlabp(11) mlabg(*1) mlabc(black)) ///
(scatter deltaa temp2a, sort m(i) mlabel(deltaa) mlabs(medsmall) mlabp(7) mlabg(*1) mlabc(black)) ///
(bar deltab temp1b, sort barw(.25) color(ltblue)) (rcap lobb upbb temp1b, sort lc(black) lw(medthin)) ///
(bar deltab temp2b, sort barw(.25) color(red)) (rcap lobb upbb temp2b, sort lc(black) lw(medthin)) ///
(scatter deltab temp1b, sort m(i) mlabel(deltab) mlabs(medsmall) mlabp(1) mlabg(*1) mlabc(black)) ///
(scatter deltab temp2b, sort m(i) mlabel(deltab) mlabs(medsmall) mlabp(5) mlabg(*1) mlabc(black)), ///
ytitle("Change in item price (in USD)") yline(0, lwidth(vthin) lcolor(black)) ylabel(-25(5)30, labsize(medsmall) format(%9.0f) angle(0) nogrid) ///
xlabel(1.5 "low price" 3.5 "medium price" 5.5 "high price", noticks labsize(medsmall)) xscale(range(0.6 6.4) noline) ///
legend(order(1 "10-fold increase in 5-star ratings" 3 "3-fold increase in non-5-star ratings" 7 "Based on OLS regression" 2 "95%-CI") ///
size(medsmall) symx(*0.5) cols(1) position(11) ring(0)) graphregion(color(white) margin(zero))
graph export graphics/FigureS1a.eps, replace logo(off)

drop temp* delta* lob* upb*


*** Figure S1B

est use tables/02sales_fereg1_2
eret di
nlcom 1.0*(exp(_b[l5ssfs]*ln(10))-1)
nlcom 1.0*(exp(_b[ln5ssfs_2]*ln(3))-1)
nlcom 2.5*(exp(_b[l5ssfs]*ln(10))-1)
nlcom 2.5*(exp(_b[ln5ssfs_2]*ln(3))-1)
nlcom 5.0*(exp(_b[l5ssfs]*ln(10))-1)
nlcom 5.0*(exp(_b[ln5ssfs_2]*ln(3))-1)

gen temp1a=1.125 in 1
gen temp2a=1.625 in 2
replace temp1a=3.125 in 3
replace temp2a=3.625 in 4
replace temp1a=5.125 in 5
replace temp2a=5.625 in 6
gen deltaa=.1473237 in 1
replace deltaa=-.1866202 in 2
replace deltaa=.3683093 in 3
replace deltaa=-.4665506 in 4
replace deltaa=.7366187 in 5
replace deltaa=-.9331012 in 6
gen loba=.0020465 in 1
replace loba=-.2858176 in 2
replace loba=.0051162 in 3
replace loba=-.7145439 in 4
replace loba=.0102325 in 5
replace loba=-1.429088 in 6
gen upba=.292601 in 1
replace upba=-.0874229 in 2
replace upba=.7315024 in 3
replace upba=-.2185573 in 4
replace upba=1.463005 in 5
replace upba=-.4371145 in 6

est use tables/01sales_ols1_2
eret di
nlcom 1.0*(exp(_b[l5ssfs]*ln(10))-1)
nlcom 1.0*(exp(_b[ln5ssfs_2]*ln(3))-1)
nlcom 2.5*(exp(_b[l5ssfs]*ln(10))-1)
nlcom 2.5*(exp(_b[ln5ssfs_2]*ln(3))-1)
nlcom 5.0*(exp(_b[l5ssfs]*ln(10))-1)
nlcom 5.0*(exp(_b[ln5ssfs_2]*ln(3))-1)

gen temp1b=1.375 in 1
gen temp2b=1.875 in 2
replace temp1b=3.375 in 3
replace temp2b=3.875 in 4
replace temp1b=5.375 in 5
replace temp2b=5.875 in 6
gen deltab=.5102792 in 1
replace deltab=-.23612 in 2
replace deltab=1.275698 in 3
replace deltab=-.5903 in 4
replace deltab=2.551396 in 5
replace deltab=-1.1806 in 6
gen lobb=.2744064 in 1
replace lobb=-.3557685 in 2
replace lobb=.6860159 in 3
replace lobb=-.8894212 in 4
replace lobb=1.372032 in 5
replace lobb=-1.778842 in 6
gen upbb=.7461521 in 1
replace upbb=-.1164715 in 2
replace upbb=1.86538 in 3
replace upbb=-.2911788 in 4
replace upbb=3.730761 in 5
replace upbb=-.5823576 in 6

format deltaa deltab %9.2f

twoway (bar deltaa temp1a, sort barw(.25) color(ltblue)) (rcap loba upba temp1a, sort lc(black) lw(medthin)) ///
(bar deltaa temp2a, sort barw(.25) color(red)) (rcap loba upba temp2a, sort lc(black) lw(medthin)) ///
(scatter deltaa temp1a, sort m(i) mlabel(deltaa) mlabs(medsmall) mlabp(11) mlabg(*1) mlabc(black)) ///
(scatter deltaa temp2a, sort m(i) mlabel(deltaa) mlabs(medsmall) mlabp(7) mlabg(*1) mlabc(black)) ///
(bar deltab temp1b, sort barw(.25) color(ltblue)) (rcap lobb upbb temp1b, sort lc(black) lw(medthin)) ///
(bar deltab temp2b, sort barw(.25) color(red)) (rcap lobb upbb temp2b, sort lc(black) lw(medthin)) ///
(scatter deltab temp1b, sort m(i) mlabel(deltab) mlabs(medsmall) mlabp(1) mlabg(*1) mlabc(black)) ///
(scatter deltab temp2b, sort m(i) mlabel(deltab) mlabs(medsmall) mlabp(5) mlabg(*1) mlabc(black)), ///
ytitle("Change in item sales per 10 days") yline(0, lwidth(vthin) lcolor(black)) ylabel(-2.0(.5)4.0, labsize(medsmall) format(%9.1f) angle(0) nogrid) ///
xlabel(1.5 "25-percentile seller" 3.5 "50-percentile seller" 5.5 "75-percentile seller", noticks labsize(medsmall)) xscale(range(0.6 6.4) noline) ///
legend(order(1 "10-fold increase in 5-star ratings" 3 "3-fold increase in non-5-star ratings" 7 "Based on OLS regression" 2 "95%-CI") ///
size(medsmall) symx(*0.5) cols(1) position(11) ring(0)) graphregion(color(white) margin(zero))
graph export graphics/FigureS1b.eps, replace logo(off)

drop temp* delta* lob* upb*


*********************************************

* (5) make tables

*********************************************

*** Table 2
* FE regressions (price and sales per day)
est use tables/02price_fereg1_2
eret di
est sto m1
est use tables/02sales_fereg1_2
eret di
est sto m2
qui: esttab m1 m2 using tables/Table2.rtf, ///
b(%9.3f) se(%9.3f) scalars(N_clust) sfmt(%9.2f) ar2(%9.2f) ///
starl(* 0.05 ** 0.01 *** 0.001) ///
title(Table 2. Regression models of item price and sales per day with seller FE) ///
mti("M1" "M2") ///
compress nogaps nonum replace

*** Table S1
* OLS regressions (price and sales per day)
est use tables/01price_ols1_2
eret di
est sto m1
est use tables/01sales_ols1_2
eret di
est sto m2
qui: esttab m1 m2 using tables/TableS1.rtf, ///
b(%9.3f) se(%9.3f) scalars(N_clust) sfmt(%9.2f) ar2(%9.2f) ///
starl(* 0.05 ** 0.01 *** 0.001) ///
title(Table S1. OLS regression models of item price per g and sales per day) ///
mti("M3" "M4") ///
compress nogaps nonum replace

*** Table S2
* Logistic regressions of probability of sale
est use tables/01sold_logit
eret di
est sto m1
est use tables/02sold_logitfe
eret di
est sto m2
qui: esttab m1 m2 using tables/TableS2.rtf, ///
b(%9.3f) se(%9.3f) scalars(N_clust) sfmt(%9.2f) ar2(%9.2f) ///
starl(* 0.05 ** 0.01 *** 0.001) ///
title(Table S1. Logistic regression models of probability of sale) ///
mti("M5" "M6") ///
compress nogaps nonum replace

* EOF